#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Holographic Torus KnotMod01.fsh by Flopine   
//https://www.shadertoy.com/view/7d3XR2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


// Based on BigWings tuts ~ https://youtu.be/2dzJZx0yngg

#define PI acos(-1.)
#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

#define pal(t,c) (vec3(0.5)+vec3(0.5)*cos(2.*PI*(c*t+vec3(0.,0.5,0.63))))
#define swi(sp) floor(sin(fract(iTime*sp)*2.*PI))+1.

float box2d (vec2 p, vec2 c)
{
    vec2 q = abs(p)-c;
    return min(0.,max(q.x,q.y))+length(max(q,0.));
}

float a;
float torus (vec3 p, vec2 rs)
{
    float s = length(p.xz)-rs.x, b = max(abs(p.x),abs(p.z))-rs.x;
    vec2 cp = mix(vec2(b,p.y),vec2(s,p.y),clamp(swi(0.2),0.,1.));
    a = atan(p.z,p.x);
    cp *= rot(a+iTime);
    cp.y = abs(abs(cp.y)-.6)-.3;
    
    float d = box2d(cp,vec2(rs.y,(rs.y+sin(a)/PI)*.35))-0.03;
    return d;
}

float SDF (vec3 p)
{
    p.yz *= rot(-atan(1./sqrt(2.)));
    p.xz *= rot(PI/4.);
    
    return torus(p,vec2(2.5,0.3));
}

vec3 getnorm (vec3 p)
{
    vec2 eps = vec2(0.001,0.);
    return normalize(SDF(p)-vec3(SDF(p-eps.xyy),SDF(p-eps.yxy),SDF(p-eps.yyx)));
}

float spec (vec3 n, vec3 l, vec3 rd)
{
    vec3 h = normalize(l-rd);
    return pow(max(dot(n,h),0.), 25.);
}

float AO (float eps, vec3 p, vec3 n)
{return SDF(p+eps*n)/eps;}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    vec3 ro=vec3(uv*3.5,-30.),rd=vec3(0.,0.,1.),p=ro,
    col=vec3(0.95,0.9,0.8),l=vec3(1.,2.,-2.);

    bool hit=false;
    
    for(float i=0.; i<60.; i++)
    {
        float d = SDF(p);
        if (d<0.01)
        {
            hit=true;break;
        }
        p += d*rd*0.65;
    }

    if (hit)
    {
        vec3 n = getnorm(p);
        float light = dot(n,normalize(l))*.5+.5, ao=AO(0.1,p,n)+AO(0.45,p,n)+AO(0.8,p,n);
        col = mix(vec3(0.,0.,0.2),pal(a/PI,vec3(2.)),light)*ao/3.+spec(n,l,rd);
    }
    
    // Output to screen
    fragColor = vec4(sqrt(col),1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

